uniform sampler2D waves;
uniform sampler2D colors;
uniform sampler2D loops;
uniform sampler2D mask;
uniform float fade;
uniform bool hasMask;

//When nbWaves==2
void main()
{
	vec2 uv = gl_TexCoord[0].st;

	float a = smoothstep(0.0, fade, min(uv.x, 1.0-uv.x));
	vec4 color = vec4(0.0,0.0,0.0,0.0);
	vec4 c;
	vec4 loop;
	float loopIn, loopOut, ca;

	float h1 = texture2D(waves, vec2(uv.x, 0.25)).x;
	c = texture2D(colors, vec2(0.25, 0.5));
	c.a *= a;
	if (uv.y >= 1.0-h1)
		color = max(color, c);

	loop = texture2D(loops, vec2(0.25, 0.5));
	loopIn = loop.r + loop.a/256.0;
	loopOut = loop.g + loop.b/256.0;
	ca = step(loopIn, uv.x)*step(uv.x, loopOut);
	c.rgb *= (1.0-uv.y);
	color = max(color, c*ca);

	float h2 = texture2D(waves, vec2(uv.x, 0.75)).x;
	c = texture2D(colors, vec2(0.75, 0.5));
	c.a *= a;
	if (uv.y >= 1.0-h2)
		color = max(color, c);

	loop = texture2D(loops, vec2(0.75, 0.5));
	loopIn = loop.r + loop.a/256.0;
	loopOut = loop.g + loop.b/256.0;
	ca = step(loopIn, uv.x)*step(uv.x, loopOut);
	c.rgb *= (1.0-uv.y);
	color = max(color, c*ca);

	if (hasMask)
		color.a *= texture2D(mask, uv).a;

	gl_FragColor = color;
}
